<?php

class Migrations_Migration741 extends Shopware\Components\Migrations\AbstractMigration
{
    public function up($modus)
    {
        $this->connection->exec(
            "UPDATE s_core_snippets SET value = 'Ms' WHERE name = 'AccountSalutationMs' AND namespace = 'frontend/account/index' AND value = 'Mrs' AND dirty = 0"
        );

        $statement = $this->connection->prepare("
            INSERT INTO s_core_snippets (namespace, shopID, localeID, name, value)
            SELECT
                'frontend/salutation' as namespace,
                shopID,
                localeID,
                :newName as name,
                value
            FROM s_core_snippets
            WHERE namespace = 'frontend/account/index'
            AND name = :name;
        ");

        $statement->execute([
            ':newName' => 'mr',
            ':name' => 'AccountSalutationMr'
        ]);

        $statement->execute([
            ':newName' => 'ms',
            ':name' => 'AccountSalutationMs'
        ]);

        $sql = <<<'EOD'
        SET @formId = (SELECT id FROM s_core_config_forms WHERE name = 'Frontend33' LIMIT 1);

INSERT INTO `s_core_config_elements` (`id`, `form_id`, `name`, `value`, `label`, `description`, `type`, `required`, `position`, `scope`, `filters`, `validators`, `options`) VALUES
(NULL, @formId, 'shopsalutations', 's:5:"mr,ms";', 'Verfügbare Anreden', 'Ermöglicht die Konfiguration welche Anreden in diesem Shop zur Verfügung stehen. Die hier definierten Keys werden automatisch als Textbaustein unter dem Namespace frontend/salutation angelegt und können dort übersetzt werden.', 'text', '0', '0', '1', NULL, NULL, NULL);
EOD;
        $this->addSql($sql);


        $sql = <<<'EOD'
        SET @elementId = (SELECT id FROM s_core_config_elements WHERE name = 'shopsalutations' LIMIT 1);
        INSERT INTO `s_core_config_element_translations` (`element_id`, `locale_id`, `label`, `description`) VALUES (@elementId, 2, 'Available salutations', 'Allows to configure the available shop salutations in frontend registration and account. Inserted keys are generated automatically as snippet inside the frontend/salutation namespace.');
EOD;
        $this->addSql($sql);



        $sql = <<<'EOD'
        SET @formId = (SELECT id FROM s_core_config_forms WHERE name = 'Frontend33' LIMIT 1);

INSERT INTO `s_core_config_elements` (`id`, `form_id`, `name`, `value`, `label`, `description`, `type`, `required`, `position`, `scope`, `filters`, `validators`, `options`) VALUES
(NULL, @formId, 'displayprofiletitle', 'b:0;', 'Titel Feld anzeigen', NULL, 'boolean', '0', '0', '1', NULL, NULL, NULL);
EOD;
        $this->addSql($sql);


        $sql = <<<'EOD'
        SET @elementId = (SELECT id FROM s_core_config_elements WHERE name = 'displayprofiletitle' LIMIT 1);
        INSERT INTO `s_core_config_element_translations` (`element_id`, `locale_id`, `label`) VALUES (@elementId, 2, 'Display title field', NULL);
EOD;
        $this->addSql($sql);


        $sql = <<<'EOD'
DELETE FROM `s_core_config_mails` WHERE dirty = 0 AND `name` IN (
	'sORDERSTATEMAIL11',
	'sORDERSTATEMAIL1',
	'sORDERSTATEMAIL2',
	'sORDERSTATEMAIL5',
	'sORDERSTATEMAIL8',
	'sORDERSTATEMAIL3',
	'sORDERSTATEMAIL4',
	'sORDERSTATEMAIL6',
	'sORDERSTATEMAIL7',
	'sBIRTHDAY',
	'sARTICLECOMMENT'
);
EOD;
        $this->addSql($sql);

        $sql = <<<'EOD'
INSERT IGNORE INTO `s_core_config_mails` (`id`, `stateId`, `name`, `frommail`, `fromname`, `subject`, `content`, `contentHTML`, `ishtml`, `attachment`, `mailtype`, `context`, `dirty`) VALUES
(NULL, 1, 'sORDERSTATEMAIL1', '{config name=mail}', '{config name=shopName}', 'Statusänderung zur Bestellung bei {config name=shopName}', '{include file="string:{config name=emailheaderplain}"}\r\n\r\nHallo {$sUser.billing_salutation|salutation} {$sUser.billing_firstname} {$sUser.billing_lastname},\n\nDer Status Ihrer Bestellung mit der Bestellnummer: {$sOrder.ordernumber} vom {$sOrder.ordertime|date_format:" %d-%m-%Y"} hat sich geändert. Der neue Status lautet nun {$sOrder.status_description}.\r\n\r\n{include file="string:{config name=emailfooterplain}"}', '', 0, '', 3, 'a:4:{s:6:"sOrder";a:40:{s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:12:"order_number";s:5:"20002";s:6:"userID";s:1:"1";s:10:"customerID";s:1:"1";s:14:"invoice_amount";s:6:"201.86";s:18:"invoice_amount_net";s:6:"169.63";s:16:"invoice_shipping";s:1:"0";s:20:"invoice_shipping_net";s:1:"0";s:9:"ordertime";s:19:"2012-08-31 08:51:46";s:6:"status";s:1:"1";s:8:"statusID";s:1:"1";s:7:"cleared";s:2:"17";s:9:"clearedID";s:2:"17";s:9:"paymentID";s:1:"4";s:13:"transactionID";s:0:"";s:7:"comment";s:0:"";s:15:"customercomment";s:0:"";s:3:"net";s:1:"0";s:5:"netto";s:1:"0";s:9:"partnerID";s:0:"";s:11:"temporaryID";s:0:"";s:7:"referer";s:0:"";s:11:"cleareddate";N;s:12:"cleared_date";N;s:12:"trackingcode";s:0:"";s:8:"language";s:1:"1";s:8:"currency";s:3:"EUR";s:14:"currencyFactor";s:1:"1";s:9:"subshopID";s:1:"1";s:10:"dispatchID";s:1:"9";s:10:"currencyID";s:1:"1";s:12:"cleared_name";s:4:"open";s:19:"cleared_description";s:5:"Offen";s:11:"status_name";s:10:"in_process";s:18:"status_description";s:23:"In Bearbeitung (Wartet)";s:19:"payment_description";s:8:"Rechnung";s:20:"dispatch_description";s:16:"Standard Versand";s:20:"currency_description";s:4:"Euro";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}s:13:"sOrderDetails";a:5:{i:0;a:20:{s:14:"orderdetailsID";s:3:"201";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"220";s:18:"articleordernumber";s:7:"SW10001";s:5:"price";s:5:"35.99";s:8:"quantity";s:1:"1";s:7:"invoice";s:5:"35.99";s:4:"name";s:27:"Versandkostenfreier Artikel";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:1;a:20:{s:14:"orderdetailsID";s:3:"202";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"227";s:18:"articleordernumber";s:10:"SW10002841";s:5:"price";s:5:"35.99";s:8:"quantity";s:1:"1";s:7:"invoice";s:5:"35.99";s:4:"name";s:27:"Aufschlag bei Zahlungsarten";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:2;a:20:{s:14:"orderdetailsID";s:3:"203";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"219";s:18:"articleordernumber";s:7:"SW10185";s:5:"price";s:4:"54.9";s:8:"quantity";s:1:"1";s:7:"invoice";s:4:"54.9";s:4:"name";s:15:"Express Versand";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:3;a:20:{s:14:"orderdetailsID";s:3:"204";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"197";s:18:"articleordernumber";s:7:"SW10196";s:5:"price";s:5:"34.99";s:8:"quantity";s:1:"2";s:7:"invoice";s:5:"69.98";s:4:"name";s:20:"ESD Download Artikel";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"1";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"1";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:4;a:20:{s:14:"orderdetailsID";s:3:"205";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:1:"0";s:18:"articleordernumber";s:19:"sw-payment-absolute";s:5:"price";s:1:"5";s:8:"quantity";s:1:"1";s:7:"invoice";s:1:"5";s:4:"name";s:25:"Zuschlag für Zahlungsart";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"4";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"0";s:3:"tax";N;s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}}s:5:"sUser";a:81:{s:15:"billing_company";s:11:"shopware AG";s:18:"billing_department";s:0:"";s:18:"billing_salutation";s:2:"mr";s:14:"customernumber";s:5:"20001";s:17:"billing_firstname";s:3:"Max";s:16:"billing_lastname";s:10:"Mustermann";s:14:"billing_street";s:20:"Mustermannstraße 92";s:32:"billing_additional_address_line1";s:0:"";s:32:"billing_additional_address_line2";s:0:"";s:15:"billing_zipcode";s:5:"48624";s:12:"billing_city";s:12:"Schöppingen";s:5:"phone";s:0:"";s:13:"billing_phone";s:0:"";s:17:"billing_countryID";s:1:"2";s:15:"billing_stateID";s:1:"3";s:15:"billing_country";s:11:"Deutschland";s:18:"billing_countryiso";s:2:"DE";s:19:"billing_countryarea";s:11:"deutschland";s:17:"billing_countryen";s:7:"GERMANY";s:5:"ustid";s:0:"";s:13:"billing_text1";N;s:13:"billing_text2";N;s:13:"billing_text3";N;s:13:"billing_text4";N;s:13:"billing_text5";N;s:13:"billing_text6";N;s:7:"orderID";s:2:"57";s:16:"shipping_company";s:11:"shopware AG";s:19:"shipping_department";s:0:"";s:19:"shipping_salutation";s:2:"mr";s:18:"shipping_firstname";s:3:"Max";s:17:"shipping_lastname";s:10:"Mustermann";s:15:"shipping_street";s:20:"Mustermannstraße 92";s:33:"shipping_additional_address_line1";s:0:"";s:33:"shipping_additional_address_line2";s:0:"";s:16:"shipping_zipcode";s:5:"48624";s:13:"shipping_city";s:12:"Schöppingen";s:16:"shipping_stateID";s:1:"0";s:18:"shipping_countryID";s:1:"2";s:16:"shipping_country";s:11:"Deutschland";s:19:"shipping_countryiso";s:2:"DE";s:20:"shipping_countryarea";s:11:"deutschland";s:18:"shipping_countryen";s:7:"GERMANY";s:14:"shipping_text1";N;s:14:"shipping_text2";N;s:14:"shipping_text3";N;s:14:"shipping_text4";N;s:14:"shipping_text5";N;s:14:"shipping_text6";N;s:2:"id";s:1:"1";s:8:"password";s:32:"a256a310bc1e5db755fd392c524028a8";s:7:"encoder";s:3:"md5";s:5:"email";s:15:"dr@shopware.com";s:6:"active";s:1:"1";s:11:"accountmode";s:1:"0";s:15:"confirmationkey";s:0:"";s:9:"paymentID";s:1:"5";s:10:"firstlogin";s:10:"2011-11-23";s:9:"lastlogin";s:19:"2012-01-04 14:12:05";s:9:"sessionID";s:26:"uiorqd755gaar8dn89ukp178c7";s:10:"newsletter";s:1:"0";s:10:"validation";s:1:"0";s:9:"affiliate";s:1:"0";s:13:"customergroup";s:2:"EK";s:13:"paymentpreset";s:1:"0";s:8:"language";s:1:"1";s:9:"subshopID";s:1:"1";s:7:"referer";s:0:"";s:12:"pricegroupID";N;s:15:"internalcomment";s:0:"";s:12:"failedlogins";s:1:"0";s:11:"lockeduntil";N;s:26:"default_billing_address_id";s:1:"1";s:27:"default_shipping_address_id";s:1:"3";s:5:"title";s:0:"";s:10:"salutation";s:2:"mr";s:9:"firstname";s:3:"Max";s:8:"lastname";s:10:"Mustermann";s:8:"birthday";N;s:11:"preisgruppe";s:1:"1";s:11:"billing_net";s:1:"1";}s:9:"sDispatch";a:2:{s:4:"name";s:16:"Standard Versand";s:11:"description";s:0:"";}}', 0),
(NULL, 2, 'sORDERSTATEMAIL2', '{config name=mail}', '{config name=shopName}', 'Statusänderung zur Bestellung bei {config name=shopName}', '{include file="string:{config name=emailheaderplain}"}\n\nHallo {$sUser.billing_salutation|salutation} {$sUser.billing_firstname} {$sUser.billing_lastname},\n\nDer Status Ihrer Bestellung mit der Bestellnummer: {$sOrder.ordernumber} vom {$sOrder.ordertime|date_format:" %d-%m-%Y"} hat sich geändert. Der neue Status lautet nun {$sOrder.status_description}.\n\n{include file="string:{config name=emailfooterplain}"}', '', 0, '', 3, 'a:4:{s:6:"sOrder";a:40:{s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:12:"order_number";s:5:"20002";s:6:"userID";s:1:"1";s:10:"customerID";s:1:"1";s:14:"invoice_amount";s:6:"201.86";s:18:"invoice_amount_net";s:6:"169.63";s:16:"invoice_shipping";s:1:"0";s:20:"invoice_shipping_net";s:1:"0";s:9:"ordertime";s:19:"2012-08-31 08:51:46";s:6:"status";s:1:"2";s:8:"statusID";s:1:"2";s:7:"cleared";s:2:"17";s:9:"clearedID";s:2:"17";s:9:"paymentID";s:1:"4";s:13:"transactionID";s:0:"";s:7:"comment";s:0:"";s:15:"customercomment";s:0:"";s:3:"net";s:1:"0";s:5:"netto";s:1:"0";s:9:"partnerID";s:0:"";s:11:"temporaryID";s:0:"";s:7:"referer";s:0:"";s:11:"cleareddate";N;s:12:"cleared_date";N;s:12:"trackingcode";s:0:"";s:8:"language";s:1:"1";s:8:"currency";s:3:"EUR";s:14:"currencyFactor";s:1:"1";s:9:"subshopID";s:1:"1";s:10:"dispatchID";s:1:"9";s:10:"currencyID";s:1:"1";s:12:"cleared_name";s:4:"open";s:19:"cleared_description";s:5:"Offen";s:11:"status_name";s:9:"completed";s:18:"status_description";s:22:"Komplett abgeschlossen";s:19:"payment_description";s:8:"Rechnung";s:20:"dispatch_description";s:16:"Standard Versand";s:20:"currency_description";s:4:"Euro";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}s:13:"sOrderDetails";a:5:{i:0;a:20:{s:14:"orderdetailsID";s:3:"201";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"220";s:18:"articleordernumber";s:7:"SW10001";s:5:"price";s:5:"35.99";s:8:"quantity";s:1:"1";s:7:"invoice";s:5:"35.99";s:4:"name";s:27:"Versandkostenfreier Artikel";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:1;a:20:{s:14:"orderdetailsID";s:3:"202";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"227";s:18:"articleordernumber";s:10:"SW10002841";s:5:"price";s:5:"35.99";s:8:"quantity";s:1:"1";s:7:"invoice";s:5:"35.99";s:4:"name";s:27:"Aufschlag bei Zahlungsarten";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:2;a:20:{s:14:"orderdetailsID";s:3:"203";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"219";s:18:"articleordernumber";s:7:"SW10185";s:5:"price";s:4:"54.9";s:8:"quantity";s:1:"1";s:7:"invoice";s:4:"54.9";s:4:"name";s:15:"Express Versand";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:3;a:20:{s:14:"orderdetailsID";s:3:"204";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"197";s:18:"articleordernumber";s:7:"SW10196";s:5:"price";s:5:"34.99";s:8:"quantity";s:1:"2";s:7:"invoice";s:5:"69.98";s:4:"name";s:20:"ESD Download Artikel";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"1";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"1";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:4;a:20:{s:14:"orderdetailsID";s:3:"205";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:1:"0";s:18:"articleordernumber";s:19:"sw-payment-absolute";s:5:"price";s:1:"5";s:8:"quantity";s:1:"1";s:7:"invoice";s:1:"5";s:4:"name";s:25:"Zuschlag für Zahlungsart";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"4";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"0";s:3:"tax";N;s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}}s:5:"sUser";a:81:{s:15:"billing_company";s:11:"shopware AG";s:18:"billing_department";s:0:"";s:18:"billing_salutation";s:2:"mr";s:14:"customernumber";s:5:"20001";s:17:"billing_firstname";s:3:"Max";s:16:"billing_lastname";s:10:"Mustermann";s:14:"billing_street";s:20:"Mustermannstraße 92";s:32:"billing_additional_address_line1";s:0:"";s:32:"billing_additional_address_line2";s:0:"";s:15:"billing_zipcode";s:5:"48624";s:12:"billing_city";s:12:"Schöppingen";s:5:"phone";s:0:"";s:13:"billing_phone";s:0:"";s:17:"billing_countryID";s:1:"2";s:15:"billing_stateID";s:1:"3";s:15:"billing_country";s:11:"Deutschland";s:18:"billing_countryiso";s:2:"DE";s:19:"billing_countryarea";s:11:"deutschland";s:17:"billing_countryen";s:7:"GERMANY";s:5:"ustid";s:0:"";s:13:"billing_text1";N;s:13:"billing_text2";N;s:13:"billing_text3";N;s:13:"billing_text4";N;s:13:"billing_text5";N;s:13:"billing_text6";N;s:7:"orderID";s:2:"57";s:16:"shipping_company";s:11:"shopware AG";s:19:"shipping_department";s:0:"";s:19:"shipping_salutation";s:2:"mr";s:18:"shipping_firstname";s:3:"Max";s:17:"shipping_lastname";s:10:"Mustermann";s:15:"shipping_street";s:20:"Mustermannstraße 92";s:33:"shipping_additional_address_line1";s:0:"";s:33:"shipping_additional_address_line2";s:0:"";s:16:"shipping_zipcode";s:5:"48624";s:13:"shipping_city";s:12:"Schöppingen";s:16:"shipping_stateID";s:1:"0";s:18:"shipping_countryID";s:1:"2";s:16:"shipping_country";s:11:"Deutschland";s:19:"shipping_countryiso";s:2:"DE";s:20:"shipping_countryarea";s:11:"deutschland";s:18:"shipping_countryen";s:7:"GERMANY";s:14:"shipping_text1";N;s:14:"shipping_text2";N;s:14:"shipping_text3";N;s:14:"shipping_text4";N;s:14:"shipping_text5";N;s:14:"shipping_text6";N;s:2:"id";s:1:"1";s:8:"password";s:32:"a256a310bc1e5db755fd392c524028a8";s:7:"encoder";s:3:"md5";s:5:"email";s:15:"dr@shopware.com";s:6:"active";s:1:"1";s:11:"accountmode";s:1:"0";s:15:"confirmationkey";s:0:"";s:9:"paymentID";s:1:"5";s:10:"firstlogin";s:10:"2011-11-23";s:9:"lastlogin";s:19:"2012-01-04 14:12:05";s:9:"sessionID";s:26:"uiorqd755gaar8dn89ukp178c7";s:10:"newsletter";s:1:"0";s:10:"validation";s:1:"0";s:9:"affiliate";s:1:"0";s:13:"customergroup";s:2:"EK";s:13:"paymentpreset";s:1:"0";s:8:"language";s:1:"1";s:9:"subshopID";s:1:"1";s:7:"referer";s:0:"";s:12:"pricegroupID";N;s:15:"internalcomment";s:0:"";s:12:"failedlogins";s:1:"0";s:11:"lockeduntil";N;s:26:"default_billing_address_id";s:1:"1";s:27:"default_shipping_address_id";s:1:"3";s:5:"title";s:0:"";s:10:"salutation";s:2:"mr";s:9:"firstname";s:3:"Max";s:8:"lastname";s:10:"Mustermann";s:8:"birthday";N;s:11:"preisgruppe";s:1:"1";s:11:"billing_net";s:1:"1";}s:9:"sDispatch";a:2:{s:4:"name";s:16:"Standard Versand";s:11:"description";s:0:"";}}', 1),
(NULL, 11, 'sORDERSTATEMAIL11', '{config name=mail}', '{config name=shopName}', 'Statusänderung zur Bestellung bei {config name=shopName}', '{include file="string:{config name=emailheaderplain}"}\r\n\r\nHallo {$sUser.billing_salutation|salutation} {$sUser.billing_firstname} {$sUser.billing_lastname},\n\nDer Status Ihrer Bestellung mit der Bestellnummer: {$sOrder.ordernumber} vom {$sOrder.ordertime|date_format:" %d-%m-%Y"} hat sich geändert.\n\nDer neue Status lautet nun {$sOrder.status_description}.\r\n\r\n{include file="string:{config name=emailfooterplain}"}', '', 0, '', 3, NULL, 0),
(NULL, 5, 'sORDERSTATEMAIL5', '{config name=mail}', '{config name=shopName}', 'Statusänderung zur Bestellung bei {config name=shopName}', '{include file="string:{config name=emailheaderplain}"}\r\n\r\nHallo {$sUser.billing_salutation|salutation} {$sUser.billing_firstname} {$sUser.billing_lastname},\n\nDer Status Ihrer Bestellung mit der Bestellnummer {$sOrder.ordernumber} vom {$sOrder.ordertime|date_format:" %d.%m.%Y"}\nhat sich geändert. Der neun Staus lautet nun {$sOrder.status_description}.\r\n\r\n{include file="string:{config name=emailfooterplain}"}', '', 0, '', 3, NULL, 0),
(NULL, 3, 'sORDERSTATEMAIL3', '{config name=mail}', '{config name=shopName}', 'Statusänderung zur Bestellung bei {config name=shopName}', '{include file="string:{config name=emailheaderplain}"}\r\n\r\nHallo {$sUser.billing_salutation|salutation} {$sUser.billing_firstname} {$sUser.billing_lastname},\n\nDer Status Ihrer Bestellung mit der Bestellnummer {$sOrder.ordernumber} vom {$sOrder.ordertime|date_format:" %d.%m.%Y"}\nhat sich geändert. Der neue Staus lautet nun "{$sOrder.status_description}".\n\n\nInformationen zu Ihrer Bestellung:\n==================================\n{foreach item=details key=position from=$sOrderDetails}\n{$position+1|fill:3} {$details.articleordernumber|fill:10:" ":"..."} {$details.name|fill:30} {$details.quantity} x {$details.price|string_format:"%.2f"} {$sConfig.sCURRENCY}\n{/foreach}\n\nVersandkosten: {$sOrder.invoice_shipping} {$sConfig.sCURRENCY}\nNetto-Gesamt: {$sOrder.invoice_amount_net|string_format:"%.2f"} {$sConfig.sCURRENCY}\nGesamtbetrag inkl. MwSt.: {$sOrder.invoice_amount|string_format:"%.2f"} {$sConfig.sCURRENCY}\r\n\r\n{include file="string:{config name=emailfooterplain}"}', '', 0, '', 3, NULL, 0),
(NULL, 8, 'sORDERSTATEMAIL8', '{config name=mail}', '{config name=shopName}', 'Statusänderung zur Bestellung bei {config name=shopName}', '{include file="string:{config name=emailheaderplain}"}\r\n\r\nHallo {$sUser.billing_salutation|salutation} {$sUser.billing_firstname} {$sUser.billing_lastname},\n\nder Bestellstatus für Ihre Bestellung {$sOrder.ordernumber} hat sich geändert!\nDie Bestellung hat jetzt den Status: {$sOrder.status_description}.\n\nDen aktuellen Status Ihrer Bestellung  können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen. Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\r\n\r\n{include file="string:{config name=emailfooterplain}"}', '', 0, '', 3, 'a:4:{s:6:"sOrder";a:40:{s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:12:"order_number";s:5:"20002";s:6:"userID";s:1:"1";s:10:"customerID";s:1:"1";s:14:"invoice_amount";s:6:"201.86";s:18:"invoice_amount_net";s:6:"169.63";s:16:"invoice_shipping";s:1:"0";s:20:"invoice_shipping_net";s:1:"0";s:9:"ordertime";s:19:"2012-08-31 08:51:46";s:6:"status";s:1:"8";s:8:"statusID";s:1:"8";s:7:"cleared";s:2:"17";s:9:"clearedID";s:2:"17";s:9:"paymentID";s:1:"4";s:13:"transactionID";s:0:"";s:7:"comment";s:0:"";s:15:"customercomment";s:0:"";s:3:"net";s:1:"0";s:5:"netto";s:1:"0";s:9:"partnerID";s:0:"";s:11:"temporaryID";s:0:"";s:7:"referer";s:0:"";s:11:"cleareddate";N;s:12:"cleared_date";N;s:12:"trackingcode";s:0:"";s:8:"language";s:1:"1";s:8:"currency";s:3:"EUR";s:14:"currencyFactor";s:1:"1";s:9:"subshopID";s:1:"2";s:10:"dispatchID";s:1:"9";s:10:"currencyID";s:1:"1";s:12:"cleared_name";s:4:"open";s:19:"cleared_description";s:5:"Offen";s:11:"status_name";s:22:"clarification_required";s:18:"status_description";s:18:"Klärung notwendig";s:19:"payment_description";s:8:"Rechnung";s:20:"dispatch_description";s:16:"Standard Versand";s:20:"currency_description";s:4:"Euro";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}s:13:"sOrderDetails";a:5:{i:0;a:20:{s:14:"orderdetailsID";s:3:"201";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"220";s:18:"articleordernumber";s:7:"SW10001";s:5:"price";s:5:"35.99";s:8:"quantity";s:1:"1";s:7:"invoice";s:5:"35.99";s:4:"name";s:27:"Versandkostenfreier Artikel";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:1;a:20:{s:14:"orderdetailsID";s:3:"202";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"227";s:18:"articleordernumber";s:10:"SW10002841";s:5:"price";s:5:"35.99";s:8:"quantity";s:1:"1";s:7:"invoice";s:5:"35.99";s:4:"name";s:27:"Aufschlag bei Zahlungsarten";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:2;a:20:{s:14:"orderdetailsID";s:3:"203";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"219";s:18:"articleordernumber";s:7:"SW10185";s:5:"price";s:4:"54.9";s:8:"quantity";s:1:"1";s:7:"invoice";s:4:"54.9";s:4:"name";s:15:"Express Versand";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:3;a:20:{s:14:"orderdetailsID";s:3:"204";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"197";s:18:"articleordernumber";s:7:"SW10196";s:5:"price";s:5:"34.99";s:8:"quantity";s:1:"2";s:7:"invoice";s:5:"69.98";s:4:"name";s:20:"ESD Download Artikel";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"1";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"1";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:4;a:20:{s:14:"orderdetailsID";s:3:"205";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:1:"0";s:18:"articleordernumber";s:19:"sw-payment-absolute";s:5:"price";s:1:"5";s:8:"quantity";s:1:"1";s:7:"invoice";s:1:"5";s:4:"name";s:25:"Zuschlag für Zahlungsart";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"4";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"0";s:3:"tax";N;s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}}s:5:"sUser";a:81:{s:15:"billing_company";s:11:"shopware AG";s:18:"billing_department";s:0:"";s:18:"billing_salutation";s:2:"mr";s:14:"customernumber";s:5:"20001";s:17:"billing_firstname";s:3:"Max";s:16:"billing_lastname";s:10:"Mustermann";s:14:"billing_street";s:20:"Mustermannstraße 92";s:32:"billing_additional_address_line1";s:0:"";s:32:"billing_additional_address_line2";s:0:"";s:15:"billing_zipcode";s:5:"48624";s:12:"billing_city";s:12:"Schöppingen";s:5:"phone";s:0:"";s:13:"billing_phone";s:0:"";s:17:"billing_countryID";s:1:"2";s:15:"billing_stateID";s:1:"3";s:15:"billing_country";s:11:"Deutschland";s:18:"billing_countryiso";s:2:"DE";s:19:"billing_countryarea";s:11:"deutschland";s:17:"billing_countryen";s:7:"GERMANY";s:5:"ustid";s:0:"";s:13:"billing_text1";N;s:13:"billing_text2";N;s:13:"billing_text3";N;s:13:"billing_text4";N;s:13:"billing_text5";N;s:13:"billing_text6";N;s:7:"orderID";s:2:"57";s:16:"shipping_company";s:11:"shopware AG";s:19:"shipping_department";s:0:"";s:19:"shipping_salutation";s:2:"mr";s:18:"shipping_firstname";s:3:"Max";s:17:"shipping_lastname";s:10:"Mustermann";s:15:"shipping_street";s:20:"Mustermannstraße 92";s:33:"shipping_additional_address_line1";s:0:"";s:33:"shipping_additional_address_line2";s:0:"";s:16:"shipping_zipcode";s:5:"48624";s:13:"shipping_city";s:12:"Schöppingen";s:16:"shipping_stateID";s:1:"0";s:18:"shipping_countryID";s:1:"2";s:16:"shipping_country";s:11:"Deutschland";s:19:"shipping_countryiso";s:2:"DE";s:20:"shipping_countryarea";s:11:"deutschland";s:18:"shipping_countryen";s:7:"GERMANY";s:14:"shipping_text1";N;s:14:"shipping_text2";N;s:14:"shipping_text3";N;s:14:"shipping_text4";N;s:14:"shipping_text5";N;s:14:"shipping_text6";N;s:2:"id";s:1:"1";s:8:"password";s:32:"a256a310bc1e5db755fd392c524028a8";s:7:"encoder";s:3:"md5";s:5:"email";s:15:"dr@shopware.com";s:6:"active";s:1:"1";s:11:"accountmode";s:1:"0";s:15:"confirmationkey";s:0:"";s:9:"paymentID";s:1:"5";s:10:"firstlogin";s:10:"2011-11-23";s:9:"lastlogin";s:19:"2012-01-04 14:12:05";s:9:"sessionID";s:26:"uiorqd755gaar8dn89ukp178c7";s:10:"newsletter";s:1:"0";s:10:"validation";s:1:"0";s:9:"affiliate";s:1:"0";s:13:"customergroup";s:2:"EK";s:13:"paymentpreset";s:1:"0";s:8:"language";s:1:"2";s:9:"subshopID";s:1:"1";s:7:"referer";s:0:"";s:12:"pricegroupID";N;s:15:"internalcomment";s:0:"";s:12:"failedlogins";s:1:"0";s:11:"lockeduntil";N;s:26:"default_billing_address_id";s:1:"1";s:27:"default_shipping_address_id";s:1:"3";s:5:"title";s:0:"";s:10:"salutation";s:2:"mr";s:9:"firstname";s:3:"Max";s:8:"lastname";s:10:"Mustermann";s:8:"birthday";N;s:11:"preisgruppe";s:1:"1";s:11:"billing_net";s:1:"1";}s:9:"sDispatch";a:2:{s:4:"name";s:16:"Standard Versand";s:11:"description";s:0:"";}}', 0),
(NULL, 4, 'sORDERSTATEMAIL4', '{config name=mail}', '{config name=shopName}', 'Statusänderung zur Bestellung bei {config name=shopName}', '{include file="string:{config name=emailheaderplain}"}\r\n\r\nHallo {$sUser.billing_salutation|salutation} {$sUser.billing_firstname} {$sUser.billing_lastname},\n\nder Bestellstatus für Ihre Bestellung {$sOrder.ordernumber} hat sich geändert!\nDie Bestellung hat jetzt den Status: {$sOrder.status_description}.\n\nDen aktuellen Status Ihrer Bestellung  können Sie  auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen. Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\r\n\r\n{include file="string:{config name=emailfooterplain}"}', '', 0, '', 3, 'a:4:{s:6:"sOrder";a:40:{s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:12:"order_number";s:5:"20002";s:6:"userID";s:1:"1";s:10:"customerID";s:1:"1";s:14:"invoice_amount";s:6:"201.86";s:18:"invoice_amount_net";s:6:"169.63";s:16:"invoice_shipping";s:1:"0";s:20:"invoice_shipping_net";s:1:"0";s:9:"ordertime";s:19:"2012-08-31 08:51:46";s:6:"status";s:1:"4";s:8:"statusID";s:1:"4";s:7:"cleared";s:2:"17";s:9:"clearedID";s:2:"17";s:9:"paymentID";s:1:"4";s:13:"transactionID";s:0:"";s:7:"comment";s:0:"";s:15:"customercomment";s:0:"";s:3:"net";s:1:"0";s:5:"netto";s:1:"0";s:9:"partnerID";s:0:"";s:11:"temporaryID";s:0:"";s:7:"referer";s:0:"";s:11:"cleareddate";N;s:12:"cleared_date";N;s:12:"trackingcode";s:0:"";s:8:"language";s:1:"2";s:8:"currency";s:3:"EUR";s:14:"currencyFactor";s:1:"1";s:9:"subshopID";s:1:"1";s:10:"dispatchID";s:1:"9";s:10:"currencyID";s:1:"1";s:12:"cleared_name";s:4:"open";s:19:"cleared_description";s:4:"Open";s:11:"status_name";s:18:"cancelled_rejected";s:18:"status_description";s:18:"Cancelled/rejected";s:19:"payment_description";s:8:"Rechnung";s:20:"dispatch_description";s:16:"Standard Versand";s:20:"currency_description";s:4:"Euro";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}s:13:"sOrderDetails";a:5:{i:0;a:20:{s:14:"orderdetailsID";s:3:"201";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"220";s:18:"articleordernumber";s:7:"SW10001";s:5:"price";s:5:"35.99";s:8:"quantity";s:1:"1";s:7:"invoice";s:5:"35.99";s:4:"name";s:27:"Versandkostenfreier Artikel";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:1;a:20:{s:14:"orderdetailsID";s:3:"202";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"227";s:18:"articleordernumber";s:10:"SW10002841";s:5:"price";s:5:"35.99";s:8:"quantity";s:1:"1";s:7:"invoice";s:5:"35.99";s:4:"name";s:27:"Aufschlag bei Zahlungsarten";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:2;a:20:{s:14:"orderdetailsID";s:3:"203";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"219";s:18:"articleordernumber";s:7:"SW10185";s:5:"price";s:4:"54.9";s:8:"quantity";s:1:"1";s:7:"invoice";s:4:"54.9";s:4:"name";s:15:"Express Versand";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:3;a:20:{s:14:"orderdetailsID";s:3:"204";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:3:"197";s:18:"articleordernumber";s:7:"SW10196";s:5:"price";s:5:"34.99";s:8:"quantity";s:1:"2";s:7:"invoice";s:5:"69.98";s:4:"name";s:20:"ESD Download Artikel";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"1";s:5:"taxID";s:1:"1";s:3:"tax";s:5:"19.00";s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"1";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:4;a:20:{s:14:"orderdetailsID";s:3:"205";s:7:"orderID";s:2:"57";s:11:"ordernumber";s:5:"20002";s:9:"articleID";s:1:"0";s:18:"articleordernumber";s:19:"sw-payment-absolute";s:5:"price";s:1:"5";s:8:"quantity";s:1:"1";s:7:"invoice";s:1:"5";s:4:"name";s:25:"Zuschlag für Zahlungsart";s:6:"status";s:1:"0";s:7:"shipped";s:1:"0";s:12:"shippedgroup";s:1:"0";s:11:"releasedate";s:10:"0000-00-00";s:5:"modus";s:1:"4";s:10:"esdarticle";s:1:"0";s:5:"taxID";s:1:"0";s:3:"tax";N;s:8:"tax_rate";s:2:"19";s:3:"esd";s:1:"0";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}}s:5:"sUser";a:81:{s:15:"billing_company";s:11:"shopware AG";s:18:"billing_department";s:0:"";s:18:"billing_salutation";s:2:"mr";s:14:"customernumber";s:5:"20001";s:17:"billing_firstname";s:3:"Max";s:16:"billing_lastname";s:10:"Mustermann";s:14:"billing_street";s:20:"Mustermannstraße 92";s:32:"billing_additional_address_line1";s:0:"";s:32:"billing_additional_address_line2";s:0:"";s:15:"billing_zipcode";s:5:"48624";s:12:"billing_city";s:12:"Schöppingen";s:5:"phone";s:0:"";s:13:"billing_phone";s:0:"";s:17:"billing_countryID";s:1:"2";s:15:"billing_stateID";s:1:"3";s:15:"billing_country";s:11:"Deutschland";s:18:"billing_countryiso";s:2:"DE";s:19:"billing_countryarea";s:11:"deutschland";s:17:"billing_countryen";s:7:"GERMANY";s:5:"ustid";s:0:"";s:13:"billing_text1";N;s:13:"billing_text2";N;s:13:"billing_text3";N;s:13:"billing_text4";N;s:13:"billing_text5";N;s:13:"billing_text6";N;s:7:"orderID";s:2:"57";s:16:"shipping_company";s:11:"shopware AG";s:19:"shipping_department";s:0:"";s:19:"shipping_salutation";s:2:"mr";s:18:"shipping_firstname";s:3:"Max";s:17:"shipping_lastname";s:10:"Mustermann";s:15:"shipping_street";s:20:"Mustermannstraße 92";s:33:"shipping_additional_address_line1";s:0:"";s:33:"shipping_additional_address_line2";s:0:"";s:16:"shipping_zipcode";s:5:"48624";s:13:"shipping_city";s:12:"Schöppingen";s:16:"shipping_stateID";s:1:"0";s:18:"shipping_countryID";s:1:"2";s:16:"shipping_country";s:11:"Deutschland";s:19:"shipping_countryiso";s:2:"DE";s:20:"shipping_countryarea";s:11:"deutschland";s:18:"shipping_countryen";s:7:"GERMANY";s:14:"shipping_text1";N;s:14:"shipping_text2";N;s:14:"shipping_text3";N;s:14:"shipping_text4";N;s:14:"shipping_text5";N;s:14:"shipping_text6";N;s:2:"id";s:1:"1";s:8:"password";s:32:"a256a310bc1e5db755fd392c524028a8";s:7:"encoder";s:3:"md5";s:5:"email";s:15:"dr@shopware.com";s:6:"active";s:1:"1";s:11:"accountmode";s:1:"0";s:15:"confirmationkey";s:0:"";s:9:"paymentID";s:1:"5";s:10:"firstlogin";s:10:"2011-11-23";s:9:"lastlogin";s:19:"2012-01-04 14:12:05";s:9:"sessionID";s:26:"uiorqd755gaar8dn89ukp178c7";s:10:"newsletter";s:1:"0";s:10:"validation";s:1:"0";s:9:"affiliate";s:1:"0";s:13:"customergroup";s:2:"EK";s:13:"paymentpreset";s:1:"0";s:8:"language";s:1:"2";s:9:"subshopID";s:1:"1";s:7:"referer";s:0:"";s:12:"pricegroupID";N;s:15:"internalcomment";s:0:"";s:12:"failedlogins";s:1:"0";s:11:"lockeduntil";N;s:26:"default_billing_address_id";s:1:"1";s:27:"default_shipping_address_id";s:1:"3";s:5:"title";s:0:"";s:10:"salutation";s:2:"mr";s:9:"firstname";s:3:"Max";s:8:"lastname";s:10:"Mustermann";s:8:"birthday";N;s:11:"preisgruppe";s:1:"1";s:11:"billing_net";s:1:"1";}s:9:"sDispatch";a:2:{s:4:"name";s:16:"Standard Versand";s:11:"description";s:0:"";}}', 0),
(NULL, 6, 'sORDERSTATEMAIL6', '{config name=mail}', '{config name=shopName}', 'Statusänderung zur Bestellung bei {config name=shopName}', '{include file="string:{config name=emailheaderplain}"}\r\n\r\nHallo {$sUser.billing_salutation|salutation} {$sUser.billing_firstname} {$sUser.billing_lastname},\n\nder Bestellstatus für Ihre Bestellung {$sOrder.ordernumber} hat sich geändert!\nDie Bestellung hat jetzt den Status: {$sOrder.status_description}.\n\nDen aktuellen Status Ihrer Bestellung  können Sie  auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen. Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\r\n\r\n{include file="string:{config name=emailfooterplain}"}', '', 0, '', 3, NULL, 0),
(NULL, 7, 'sORDERSTATEMAIL7', '{config name=mail}', '{config name=shopName}', 'Statusänderung zur Bestellung bei {config name=shopName}', '{include file="string:{config name=emailheaderplain}"}\r\n\r\nHallo {$sUser.billing_salutation|salutation} {$sUser.billing_firstname} {$sUser.billing_lastname},\n\nder Bestellstatus für Ihre Bestellung {$sOrder.ordernumber} hat sich geändert!\nDie Bestellung hat jetzt den Status: {$sOrder.status_description}.\n\nDen aktuellen Status Ihrer Bestellung  können Sie  auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen. Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\r\n\r\n{include file="string:{config name=emailfooterplain}"}', '', 0, '', 3, 'a:3:{s:5:"sShop";s:13:"Shopware Demo";s:8:"sShopURL";s:20:"http://localhost/5.1";s:7:"sConfig";a:0:{}}', 0),
(NULL, NULL, 'sBIRTHDAY', '{config name=mail}', '{config name=shopName}', 'Herzlichen Glückwunsch zum Geburtstag von {config name=shopName}', '{include file="string:{config name=emailheaderplain}"}\r\n\r\nHallo {$sUser.salutation|salutation} {$sUser.firstname} {$sUser.lastname},\n\nwir wünschen Ihnen alles Gute zum Geburtstag.\r\n\r\n{include file="string:{config name=emailfooterplain}"}', '', 0, '', 2, NULL, 0),
(NULL, NULL, 'sARTICLECOMMENT', '{config name=mail}', '{config name=shopName}', 'Artikel bewerten', '{include file="string:{config name=emailheaderplain}"}\r\n\r\nHallo {$sUser.billing_salutation|salutation} {$sUser.billing_firstname} {$sUser.billing_lastname},\n\nSie haben bei uns vor einigen Tagen Artikel gekauft. Wir würden uns freuen, wenn Sie diese Artikel bewerten würden.<br/>\nSo helfen Sie uns, unseren Service weiter zu steigern und Sie können auf diesem Weg anderen Interessenten direkt Ihre Meinung mitteilen.\n\n\nHier finden Sie die Links zum Bewerten der von Ihnen gekauften Produkte.\n\n{foreach from=$sArticles item=sArticle key=key}\n{if !$sArticle.modus}\n{$sArticle.articleordernumber} {$sArticle.name} {$sArticle.link}\n{/if}\n{/foreach}\r\n\r\n{include file="string:{config name=emailfooterplain}"}', '{include file="string:{config name=emailheaderhtml}"}\r\n<br/><br/>\r\nHallo {if $sUser.salutation eq "mr"}Herr{elseif $sUser.billing_salutation eq "ms"}Frau{/if} {$sUser.billing_firstname} {$sUser.billing_lastname},\n<br/>\nSie haben bei uns vor einigen Tagen Artikel gekauft. Wir würden uns freuen, wenn Sie diese Artikel bewerten würden.<br/>\nSo helfen Sie uns, unseren Service weiter zu steigern und Sie können auf diesem Weg anderen Interessenten direkt Ihre Meinung mitteilen.\n<br/><br/>\n\nHier finden Sie die Links zum Bewerten der von Ihnen gekauften Produkte.\n\n<table>\n {foreach from=$sArticles item=sArticle key=key}\n{if !$sArticle.modus}\n <tr>\n  <td>{$sArticle.articleordernumber}</td>\n  <td>{$sArticle.name}</td>\n  <td>\n  <a href="{$sArticle.link}">link</a>\n  </td>\n </tr>\n{/if}\n {/foreach}\n</table>\r\n<br/><br/>\r\n{include file="string:{config name=emailfooterhtml}"}', 1, '', 2, NULL, 0);

EOD;

        $this->addSql($sql);
    }
}
